import { world, system, BlockPermutation, ItemStack } from '@minecraft/server'

world.afterEvents.playerBreakBlock.subscribe(data => {
    const block = data.block
    const player = data.player
    const { x, y, z } = block.location
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    const destroyedBlock = data.brokenBlockPermutation.type.id
    const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe')
    const itemBlueberry = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:blueberry_bush.name', closest: 1 })
    const itemGarnet = data.dimension.getEntities({ type: 'minecraft:item', name: 'item.v360:garnet.name', closest: 1 })
    const itemGargot = data.dimension.getEntities({ type: 'minecraft:item', name: 'item.v360:gargot.name', closest: 1 })
    const itemTallGargot = data.dimension.getEntities({ type: 'minecraft:item', name: 'item.v360:tall_gargot.name', closest: 1 })
    const itemGarpite = data.dimension.getEntities({ type: 'minecraft:item', name: 'item.v360:garpite.name', closest: 1 })
    const itemBlueBonnetsWaxed0 = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:blue_bonnets_waxed0.name', closest: 1 })
    const itemBlueBonnetsWaxed1 = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:blue_bonnets_waxed1.name', closest: 1 })
    const itemAraucariaFence = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:araucaria_fence_block.name', closest: 1 })
    const itemEndFence = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:end_fence_block.name', closest: 1 })
    if (!selectedItem) return
    else if (!selectedItem.hasComponent('enchantable')) return
    else if (player.getGameMode === 'creative') return
    else if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch') && destroyedBlock === 'v360:citrine_cluster') {
        system.run(() => {
            block.dimension.runCommand(`loot spawn ${x} ${y} ${z} loot citrine_cluster1`)
        })
    }
    else if (!isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch') && (destroyedBlock === 'v360:garnet' || destroyedBlock === 'v360:gargot' || destroyedBlock === 'v360:tall_gargot')) return
    if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch') && (destroyedBlock === 'v360:garnet' || destroyedBlock === 'v360:gargot' || destroyedBlock === 'v360:tall_gargot')) {
        block.dimension.runCommand(`loot spawn ${x} ${y} ${z} loot garnet`)
    }
    else if (player.getGameMode() !== 'creative' && selectedItem && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
        if (destroyedBlock === 'v360:blueberry_bush') {
            itemBlueberry[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:blueberries', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:garnet') {
            itemGarnet[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:garnet_cluster', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:gargot') {
            itemGargot[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:gargot_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:garpite') {
            itemGarpite[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:garpite_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:tall_gargot') {
            itemTallGargot[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:tall_gargot_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:blue_bonnets_waxed0') {
            itemBlueBonnetsWaxed0[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:blue_bonnets_seeds', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:blue_bonnets_waxed1') {
            itemBlueBonnetsWaxed1[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:blue_bonnets_seeds', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:araucaria_fence_block') {
            itemAraucariaFence[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:araucaria_fence'), block.center())
        }
        else if (isPickaxe && destroyedBlock === 'v360:end_fence_block') {
            itemEndFence[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:end_fence'), block.center())
        }
    }
})

world.afterEvents.playerBreakBlock.subscribe(data => {
    const block = data.block
    const player = data.player
    const { x, y, z } = block.location
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    const destroyedBlock = data.brokenBlockPermutation.type.id
    const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe')
    if (!isPickaxe && player.getGameMode() !== 'creative' && destroyedBlock === 'v360:citrine_cluster') {
        block.dimension.runCommand(`loot spawn ${x} ${y} ${z} loot citrine_cluster0`)
    }
})